%------------------------------------------------------------------------------
% File     : DAT199^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Sorted list operations 19
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Lam09] Lammich (2009), Collections Framework
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : sorted_list_operations__19.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  349 ( 129 unt;  53 typ;   0 def)
%            Number of atoms       :  681 ( 323 equ;   0 cnn)
%            Maximal formula atoms :   10 (   2 avg)
%            Number of connectives : 4315 (  92   ~;  14   |;  69   &;3818   @)
%                                         (   0 <=>; 322  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   7 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  224 ( 224   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   54 (  51 usr;   4 con; 0-5 aty)
%            Number of variables   : 1087 (  43   ^; 978   !;  18   ?;1087   :)
%                                         (  48  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:40:16.282
%------------------------------------------------------------------------------
%----Could-be-implicit typings (6)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (47)
thf(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Odistrib__lattice,type,
    distrib_lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Obounded__semilattice__sup__bot,type,
    bounde1808546759up_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Finite__Set_Ofinite,type,
    finite_finite2: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_List_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : ( ( list @ A ) > ( A > ( list @ B ) ) > ( list @ B ) ) ).

thf(sy_c_List_Ocan__select,type,
    can_select: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ A ) ) ).

thf(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Ofold,type,
    fold: 
      !>[A: $tType,B: $tType] : ( ( A > B > B ) > ( list @ A ) > B > B ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olinorder__class_Osorted__list__of__set,type,
    linord467138063of_set: 
      !>[A: $tType] : ( ( set @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list @ A ) > A > $o ) ).

thf(sy_c_List_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( nat > ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Oproduct,type,
    product: 
      !>[A: $tType,B: $tType] : ( ( list @ A ) > ( list @ B ) > ( list @ ( product_prod @ A @ B ) ) ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Misc_Omerge,type,
    merge: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Misc_Omergesort__by__rel__merge,type,
    merges2133357844_merge: 
      !>[A: $tType] : ( ( A > A > $o ) > ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Misc_Omergesort__remdups,type,
    mergesort_remdups: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Odisjnt,type,
    disjnt: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ A ) > $o ) ).

thf(sy_c_Set_Oinsert,type,
    insert2: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Sorted__List__Operations__Mirabelle__fineeiboro_Ointer__sorted,type,
    sorted2037043510sorted: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_member,type,
    member2: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_l1,type,
    l1: list @ a ).

thf(sy_v_l2,type,
    l2: list @ a ).

%----Relevant facts (255)
thf(fact_0_l1__OK,axiom,
    ( ( distinct @ a @ l1 )
    & ( linorder_sorted @ a @ l1 ) ) ).

% l1_OK
thf(fact_1_l2__OK,axiom,
    ( ( distinct @ a @ l2 )
    & ( linorder_sorted @ a @ l2 ) ) ).

% l2_OK
thf(fact_2_sorted__distinct__set__unique,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ( distinct @ A @ Xs )
           => ( ( linorder_sorted @ A @ Ys )
             => ( ( distinct @ A @ Ys )
               => ( ( ( set2 @ A @ Xs )
                    = ( set2 @ A @ Ys ) )
                 => ( Xs = Ys ) ) ) ) ) ) ) ).

% sorted_distinct_set_unique
thf(fact_3_IntI,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ A2 )
     => ( ( member2 @ A @ C @ B2 )
       => ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) ) ).

% IntI
thf(fact_4_Int__iff,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) )
      = ( ( member2 @ A @ C @ A2 )
        & ( member2 @ A @ C @ B2 ) ) ) ).

% Int_iff
thf(fact_5_inf__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_inf @ B @ ( type2 @ B ) )
     => ( ( inf_inf @ ( A > B ) )
        = ( ^ [F: A > B,G: A > B,X: A] : ( inf_inf @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ) ).

% inf_apply
thf(fact_6_inf_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ( ( inf_inf @ A @ A3 @ A3 )
          = A3 ) ) ).

% inf.idem
thf(fact_7_inf__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X2: A] :
          ( ( inf_inf @ A @ X2 @ X2 )
          = X2 ) ) ).

% inf_idem
thf(fact_8_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( inf_inf @ A @ A3 @ ( inf_inf @ A @ A3 @ B3 ) )
          = ( inf_inf @ A @ A3 @ B3 ) ) ) ).

% inf.left_idem
thf(fact_9_inf__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( inf_inf @ A @ X2 @ ( inf_inf @ A @ X2 @ Y ) )
          = ( inf_inf @ A @ X2 @ Y ) ) ) ).

% inf_left_idem
thf(fact_10_inf_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A3 @ B3 ) @ B3 )
          = ( inf_inf @ A @ A3 @ B3 ) ) ) ).

% inf.right_idem
thf(fact_11_inf__right__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X2 @ Y ) @ Y )
          = ( inf_inf @ A @ X2 @ Y ) ) ) ).

% inf_right_idem
thf(fact_12_mergesort__remdups__correct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L: list @ A] :
          ( ( distinct @ A @ ( mergesort_remdups @ A @ L ) )
          & ( linorder_sorted @ A @ ( mergesort_remdups @ A @ L ) )
          & ( ( set2 @ A @ ( mergesort_remdups @ A @ L ) )
            = ( set2 @ A @ L ) ) ) ) ).

% mergesort_remdups_correct
thf(fact_13_IntE,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) )
     => ~ ( ( member2 @ A @ C @ A2 )
         => ~ ( member2 @ A @ C @ B2 ) ) ) ).

% IntE
thf(fact_14_inf__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X2 @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X2 @ Z ) ) ) ) ).

% inf_left_commute
thf(fact_15_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( inf_inf @ A @ B3 @ ( inf_inf @ A @ A3 @ C ) )
          = ( inf_inf @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ).

% inf.left_commute
thf(fact_16_inf__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X: A,Y2: A] : ( inf_inf @ A @ Y2 @ X ) ) ) ) ).

% inf_commute
thf(fact_17_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [A4: A,B4: A] : ( inf_inf @ A @ B4 @ A4 ) ) ) ) ).

% inf.commute
thf(fact_18_inf__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X2 @ Y ) @ Z )
          = ( inf_inf @ A @ X2 @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_assoc
thf(fact_19_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C )
          = ( inf_inf @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ).

% inf.assoc
thf(fact_20_inf__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_inf @ B @ ( type2 @ B ) )
     => ( ( inf_inf @ ( A > B ) )
        = ( ^ [F: A > B,G: A > B,X: A] : ( inf_inf @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ) ).

% inf_fun_def
thf(fact_21_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X: A,Y2: A] : ( inf_inf @ A @ Y2 @ X ) ) ) ) ).

% inf_sup_aci(1)
thf(fact_22_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X2 @ Y ) @ Z )
          = ( inf_inf @ A @ X2 @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_sup_aci(2)
thf(fact_23_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X2 @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X2 @ Z ) ) ) ) ).

% inf_sup_aci(3)
thf(fact_24_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( inf_inf @ A @ X2 @ ( inf_inf @ A @ X2 @ Y ) )
          = ( inf_inf @ A @ X2 @ Y ) ) ) ).

% inf_sup_aci(4)
thf(fact_25_Int__left__commute,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ B2 @ C2 ) )
      = ( inf_inf @ ( set @ A ) @ B2 @ ( inf_inf @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% Int_left_commute
thf(fact_26_Int__left__absorb,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) )
      = ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ).

% Int_left_absorb
thf(fact_27_Int__commute,axiom,
    ! [A: $tType] :
      ( ( inf_inf @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] : ( inf_inf @ ( set @ A ) @ B5 @ A5 ) ) ) ).

% Int_commute
thf(fact_28_Int__absorb,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ A2 )
      = A2 ) ).

% Int_absorb
thf(fact_29_Int__assoc,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) @ C2 )
      = ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ B2 @ C2 ) ) ) ).

% Int_assoc
thf(fact_30_IntD2,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) )
     => ( member2 @ A @ C @ B2 ) ) ).

% IntD2
thf(fact_31_IntD1,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) )
     => ( member2 @ A @ C @ A2 ) ) ).

% IntD1
thf(fact_32_distinct__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( distinct @ A @ ( union @ A @ Xs @ Ys ) )
      = ( distinct @ A @ Ys ) ) ).

% distinct_union
thf(fact_33_in__set__member,axiom,
    ! [A: $tType,X2: A,Xs: list @ A] :
      ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
      = ( member @ A @ Xs @ X2 ) ) ).

% in_set_member
thf(fact_34_finite__sorted__distinct__unique,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A2: set @ A] :
          ( ( finite_finite2 @ A @ A2 )
         => ? [X3: list @ A] :
              ( ( ( set2 @ A @ X3 )
                = A2 )
              & ( linorder_sorted @ A @ X3 )
              & ( distinct @ A @ X3 )
              & ! [Y3: list @ A] :
                  ( ( ( ( set2 @ A @ Y3 )
                      = A2 )
                    & ( linorder_sorted @ A @ Y3 )
                    & ( distinct @ A @ Y3 ) )
                 => ( Y3 = X3 ) ) ) ) ) ).

% finite_sorted_distinct_unique
thf(fact_35_distinct__insert,axiom,
    ! [A: $tType,X2: A,Xs: list @ A] :
      ( ( distinct @ A @ ( insert @ A @ X2 @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_insert
thf(fact_36_in__set__insert,axiom,
    ! [A: $tType,X2: A,Xs: list @ A] :
      ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X2 @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_37_list__ex1__iff,axiom,
    ! [A: $tType] :
      ( ( list_ex1 @ A )
      = ( ^ [P: A > $o,Xs2: list @ A] :
          ? [X: A] :
            ( ( member2 @ A @ X @ ( set2 @ A @ Xs2 ) )
            & ( P @ X )
            & ! [Y2: A] :
                ( ( ( member2 @ A @ Y2 @ ( set2 @ A @ Xs2 ) )
                  & ( P @ Y2 ) )
               => ( Y2 = X ) ) ) ) ) ).

% list_ex1_iff
thf(fact_38_distinct1__rotate,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct @ A @ ( rotate1 @ A @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct1_rotate
thf(fact_39_set__rotate1,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( rotate1 @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% set_rotate1
thf(fact_40_list__bind__cong,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,Ys: list @ A,F2: A > ( list @ B ),G2: A > ( list @ B )] :
      ( ( Xs = Ys )
     => ( ! [X3: A] :
            ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
           => ( ( F2 @ X3 )
              = ( G2 @ X3 ) ) )
       => ( ( bind @ A @ B @ Xs @ F2 )
          = ( bind @ A @ B @ Ys @ G2 ) ) ) ) ).

% list_bind_cong
thf(fact_41_distinct__product__lists,axiom,
    ! [A: $tType,Xss: list @ ( list @ A )] :
      ( ! [X3: list @ A] :
          ( ( member2 @ ( list @ A ) @ X3 @ ( set2 @ ( list @ A ) @ Xss ) )
         => ( distinct @ A @ X3 ) )
     => ( distinct @ ( list @ A ) @ ( product_lists @ A @ Xss ) ) ) ).

% distinct_product_lists
thf(fact_42_distinct__product,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Ys: list @ B] :
      ( ( distinct @ A @ Xs )
     => ( ( distinct @ B @ Ys )
       => ( distinct @ ( product_prod @ A @ B ) @ ( product @ A @ B @ Xs @ Ys ) ) ) ) ).

% distinct_product
thf(fact_43_List_Ofinite__set,axiom,
    ! [A: $tType,Xs: list @ A] : ( finite_finite2 @ A @ ( set2 @ A @ Xs ) ) ).

% List.finite_set
thf(fact_44_finite__list,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( finite_finite2 @ A @ A2 )
     => ? [Xs3: list @ A] :
          ( ( set2 @ A @ Xs3 )
          = A2 ) ) ).

% finite_list
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A3: A,P2: A > $o] :
      ( ( member2 @ A @ A3 @ ( collect @ A @ P2 ) )
      = ( P2 @ A3 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member2 @ A @ X @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P2 @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P2 )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F2: A > B,G2: A > B] :
      ( ! [X3: A] :
          ( ( F2 @ X3 )
          = ( G2 @ X3 ) )
     => ( F2 = G2 ) ) ).

% ext
thf(fact_49_finite__distinct__list,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( finite_finite2 @ A @ A2 )
     => ? [Xs3: list @ A] :
          ( ( ( set2 @ A @ Xs3 )
            = A2 )
          & ( distinct @ A @ Xs3 ) ) ) ).

% finite_distinct_list
thf(fact_50_finite__Int,axiom,
    ! [A: $tType,F3: set @ A,G3: set @ A] :
      ( ( ( finite_finite2 @ A @ F3 )
        | ( finite_finite2 @ A @ G3 ) )
     => ( finite_finite2 @ A @ ( inf_inf @ ( set @ A ) @ F3 @ G3 ) ) ) ).

% finite_Int
thf(fact_51_can__select__set__list__ex1,axiom,
    ! [A: $tType,P2: A > $o,A2: list @ A] :
      ( ( can_select @ A @ P2 @ ( set2 @ A @ A2 ) )
      = ( list_ex1 @ A @ P2 @ A2 ) ) ).

% can_select_set_list_ex1
thf(fact_52_finite__code,axiom,
    ! [A: $tType] :
      ( ( finite_finite @ A @ ( type2 @ A ) )
     => ( ( finite_finite2 @ A )
        = ( ^ [A5: set @ A] : $true ) ) ) ).

% finite_code
thf(fact_53_sorted__list__of__set,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A2: set @ A] :
          ( ( finite_finite2 @ A @ A2 )
         => ( ( ( set2 @ A @ ( linord467138063of_set @ A @ A2 ) )
              = A2 )
            & ( linorder_sorted @ A @ ( linord467138063of_set @ A @ A2 ) )
            & ( distinct @ A @ ( linord467138063of_set @ A @ A2 ) ) ) ) ) ).

% sorted_list_of_set
thf(fact_54_set__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( set2 @ A @ ( union @ A @ Xs @ Ys ) )
      = ( sup_sup @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ Ys ) ) ) ).

% set_union
thf(fact_55_List_Ounion__def,axiom,
    ! [A: $tType] :
      ( ( union @ A )
      = ( fold @ A @ ( list @ A ) @ ( insert @ A ) ) ) ).

% List.union_def
thf(fact_56_finite,axiom,
    ! [A: $tType] :
      ( ( finite_finite @ A @ ( type2 @ A ) )
     => ! [A2: set @ A] : ( finite_finite2 @ A @ A2 ) ) ).

% finite
thf(fact_57_finite__set__choice,axiom,
    ! [B: $tType,A: $tType,A2: set @ A,P2: A > B > $o] :
      ( ( finite_finite2 @ A @ A2 )
     => ( ! [X3: A] :
            ( ( member2 @ A @ X3 @ A2 )
           => ? [X1: B] : ( P2 @ X3 @ X1 ) )
       => ? [F4: A > B] :
          ! [X4: A] :
            ( ( member2 @ A @ X4 @ A2 )
           => ( P2 @ X4 @ ( F4 @ X4 ) ) ) ) ) ).

% finite_set_choice
thf(fact_58_sup_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A3 @ B3 ) @ B3 )
          = ( sup_sup @ A @ A3 @ B3 ) ) ) ).

% sup.right_idem
thf(fact_59_sup__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( sup_sup @ A @ X2 @ ( sup_sup @ A @ X2 @ Y ) )
          = ( sup_sup @ A @ X2 @ Y ) ) ) ).

% sup_left_idem
thf(fact_60_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( sup_sup @ A @ A3 @ ( sup_sup @ A @ A3 @ B3 ) )
          = ( sup_sup @ A @ A3 @ B3 ) ) ) ).

% sup.left_idem
thf(fact_61_sup__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X2: A] :
          ( ( sup_sup @ A @ X2 @ X2 )
          = X2 ) ) ).

% sup_idem
thf(fact_62_sup_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ( ( sup_sup @ A @ A3 @ A3 )
          = A3 ) ) ).

% sup.idem
thf(fact_63_sup__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B @ ( type2 @ B ) )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F: A > B,G: A > B,X: A] : ( sup_sup @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ) ).

% sup_apply
thf(fact_64_Un__iff,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
      = ( ( member2 @ A @ C @ A2 )
        | ( member2 @ A @ C @ B2 ) ) ) ).

% Un_iff
thf(fact_65_UnCI,axiom,
    ! [A: $tType,C: A,B2: set @ A,A2: set @ A] :
      ( ( ~ ( member2 @ A @ C @ B2 )
       => ( member2 @ A @ C @ A2 ) )
     => ( member2 @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% UnCI
thf(fact_66_sup__inf__absorb,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( sup_sup @ A @ X2 @ ( inf_inf @ A @ X2 @ Y ) )
          = X2 ) ) ).

% sup_inf_absorb
thf(fact_67_inf__sup__absorb,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( inf_inf @ A @ X2 @ ( sup_sup @ A @ X2 @ Y ) )
          = X2 ) ) ).

% inf_sup_absorb
thf(fact_68_finite__Un,axiom,
    ! [A: $tType,F3: set @ A,G3: set @ A] :
      ( ( finite_finite2 @ A @ ( sup_sup @ ( set @ A ) @ F3 @ G3 ) )
      = ( ( finite_finite2 @ A @ F3 )
        & ( finite_finite2 @ A @ G3 ) ) ) ).

% finite_Un
thf(fact_69_infinite__Un,axiom,
    ! [A: $tType,S: set @ A,T: set @ A] :
      ( ( ~ ( finite_finite2 @ A @ ( sup_sup @ ( set @ A ) @ S @ T ) ) )
      = ( ~ ( finite_finite2 @ A @ S )
        | ~ ( finite_finite2 @ A @ T ) ) ) ).

% infinite_Un
thf(fact_70_Un__infinite,axiom,
    ! [A: $tType,S: set @ A,T: set @ A] :
      ( ~ ( finite_finite2 @ A @ S )
     => ~ ( finite_finite2 @ A @ ( sup_sup @ ( set @ A ) @ S @ T ) ) ) ).

% Un_infinite
thf(fact_71_finite__UnI,axiom,
    ! [A: $tType,F3: set @ A,G3: set @ A] :
      ( ( finite_finite2 @ A @ F3 )
     => ( ( finite_finite2 @ A @ G3 )
       => ( finite_finite2 @ A @ ( sup_sup @ ( set @ A ) @ F3 @ G3 ) ) ) ) ).

% finite_UnI
thf(fact_72_sup__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ X2 @ ( sup_sup @ A @ Y @ Z ) )
          = ( sup_sup @ A @ Y @ ( sup_sup @ A @ X2 @ Z ) ) ) ) ).

% sup_left_commute
thf(fact_73_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( sup_sup @ A @ B3 @ ( sup_sup @ A @ A3 @ C ) )
          = ( sup_sup @ A @ A3 @ ( sup_sup @ A @ B3 @ C ) ) ) ) ).

% sup.left_commute
thf(fact_74_sup__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [X: A,Y2: A] : ( sup_sup @ A @ Y2 @ X ) ) ) ) ).

% sup_commute
thf(fact_75_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [A4: A,B4: A] : ( sup_sup @ A @ B4 @ A4 ) ) ) ) ).

% sup.commute
thf(fact_76_sup__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X2 @ Y ) @ Z )
          = ( sup_sup @ A @ X2 @ ( sup_sup @ A @ Y @ Z ) ) ) ) ).

% sup_assoc
thf(fact_77_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A3 @ B3 ) @ C )
          = ( sup_sup @ A @ A3 @ ( sup_sup @ A @ B3 @ C ) ) ) ) ).

% sup.assoc
thf(fact_78_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B @ ( type2 @ B ) )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F: A > B,G: A > B,X: A] : ( sup_sup @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ) ).

% sup_fun_def
thf(fact_79_Un__left__commute,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ B2 @ C2 ) )
      = ( sup_sup @ ( set @ A ) @ B2 @ ( sup_sup @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% Un_left_commute
thf(fact_80_Un__left__absorb,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
      = ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ).

% Un_left_absorb
thf(fact_81_Un__commute,axiom,
    ! [A: $tType] :
      ( ( sup_sup @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] : ( sup_sup @ ( set @ A ) @ B5 @ A5 ) ) ) ).

% Un_commute
thf(fact_82_Un__absorb,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ A2 )
      = A2 ) ).

% Un_absorb
thf(fact_83_Un__assoc,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) @ C2 )
      = ( sup_sup @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ B2 @ C2 ) ) ) ).

% Un_assoc
thf(fact_84_ball__Un,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,P2: A > $o] :
      ( ( ! [X: A] :
            ( ( member2 @ A @ X @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
           => ( P2 @ X ) ) )
      = ( ! [X: A] :
            ( ( member2 @ A @ X @ A2 )
           => ( P2 @ X ) )
        & ! [X: A] :
            ( ( member2 @ A @ X @ B2 )
           => ( P2 @ X ) ) ) ) ).

% ball_Un
thf(fact_85_bex__Un,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,P2: A > $o] :
      ( ( ? [X: A] :
            ( ( member2 @ A @ X @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
            & ( P2 @ X ) ) )
      = ( ? [X: A] :
            ( ( member2 @ A @ X @ A2 )
            & ( P2 @ X ) )
        | ? [X: A] :
            ( ( member2 @ A @ X @ B2 )
            & ( P2 @ X ) ) ) ) ).

% bex_Un
thf(fact_86_UnI2,axiom,
    ! [A: $tType,C: A,B2: set @ A,A2: set @ A] :
      ( ( member2 @ A @ C @ B2 )
     => ( member2 @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% UnI2
thf(fact_87_UnI1,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ A2 )
     => ( member2 @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% UnI1
thf(fact_88_UnE,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
     => ( ~ ( member2 @ A @ C @ A2 )
       => ( member2 @ A @ C @ B2 ) ) ) ).

% UnE
thf(fact_89_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [X: A,Y2: A] : ( sup_sup @ A @ Y2 @ X ) ) ) ) ).

% inf_sup_aci(5)
thf(fact_90_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X2 @ Y ) @ Z )
          = ( sup_sup @ A @ X2 @ ( sup_sup @ A @ Y @ Z ) ) ) ) ).

% inf_sup_aci(6)
thf(fact_91_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ X2 @ ( sup_sup @ A @ Y @ Z ) )
          = ( sup_sup @ A @ Y @ ( sup_sup @ A @ X2 @ Z ) ) ) ) ).

% inf_sup_aci(7)
thf(fact_92_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( sup_sup @ A @ X2 @ ( sup_sup @ A @ X2 @ Y ) )
          = ( sup_sup @ A @ X2 @ Y ) ) ) ).

% inf_sup_aci(8)
thf(fact_93_sup__inf__distrib2,axiom,
    ! [A: $tType] :
      ( ( distrib_lattice @ A @ ( type2 @ A ) )
     => ! [Y: A,Z: A,X2: A] :
          ( ( sup_sup @ A @ ( inf_inf @ A @ Y @ Z ) @ X2 )
          = ( inf_inf @ A @ ( sup_sup @ A @ Y @ X2 ) @ ( sup_sup @ A @ Z @ X2 ) ) ) ) ).

% sup_inf_distrib2
thf(fact_94_sup__inf__distrib1,axiom,
    ! [A: $tType] :
      ( ( distrib_lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( sup_sup @ A @ X2 @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ ( sup_sup @ A @ X2 @ Y ) @ ( sup_sup @ A @ X2 @ Z ) ) ) ) ).

% sup_inf_distrib1
thf(fact_95_inf__sup__distrib2,axiom,
    ! [A: $tType] :
      ( ( distrib_lattice @ A @ ( type2 @ A ) )
     => ! [Y: A,Z: A,X2: A] :
          ( ( inf_inf @ A @ ( sup_sup @ A @ Y @ Z ) @ X2 )
          = ( sup_sup @ A @ ( inf_inf @ A @ Y @ X2 ) @ ( inf_inf @ A @ Z @ X2 ) ) ) ) ).

% inf_sup_distrib2
thf(fact_96_inf__sup__distrib1,axiom,
    ! [A: $tType] :
      ( ( distrib_lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X2 @ ( sup_sup @ A @ Y @ Z ) )
          = ( sup_sup @ A @ ( inf_inf @ A @ X2 @ Y ) @ ( inf_inf @ A @ X2 @ Z ) ) ) ) ).

% inf_sup_distrib1
thf(fact_97_distrib__imp2,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ! [X3: A,Y4: A,Z2: A] :
              ( ( sup_sup @ A @ X3 @ ( inf_inf @ A @ Y4 @ Z2 ) )
              = ( inf_inf @ A @ ( sup_sup @ A @ X3 @ Y4 ) @ ( sup_sup @ A @ X3 @ Z2 ) ) )
         => ( ( inf_inf @ A @ X2 @ ( sup_sup @ A @ Y @ Z ) )
            = ( sup_sup @ A @ ( inf_inf @ A @ X2 @ Y ) @ ( inf_inf @ A @ X2 @ Z ) ) ) ) ) ).

% distrib_imp2
thf(fact_98_distrib__imp1,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A,Z: A] :
          ( ! [X3: A,Y4: A,Z2: A] :
              ( ( inf_inf @ A @ X3 @ ( sup_sup @ A @ Y4 @ Z2 ) )
              = ( sup_sup @ A @ ( inf_inf @ A @ X3 @ Y4 ) @ ( inf_inf @ A @ X3 @ Z2 ) ) )
         => ( ( sup_sup @ A @ X2 @ ( inf_inf @ A @ Y @ Z ) )
            = ( inf_inf @ A @ ( sup_sup @ A @ X2 @ Y ) @ ( sup_sup @ A @ X2 @ Z ) ) ) ) ) ).

% distrib_imp1
thf(fact_99_Un__Int__distrib2,axiom,
    ! [A: $tType,B2: set @ A,C2: set @ A,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ B2 @ C2 ) @ A2 )
      = ( inf_inf @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ B2 @ A2 ) @ ( sup_sup @ ( set @ A ) @ C2 @ A2 ) ) ) ).

% Un_Int_distrib2
thf(fact_100_Int__Un__distrib2,axiom,
    ! [A: $tType,B2: set @ A,C2: set @ A,A2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ B2 @ C2 ) @ A2 )
      = ( sup_sup @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ B2 @ A2 ) @ ( inf_inf @ ( set @ A ) @ C2 @ A2 ) ) ) ).

% Int_Un_distrib2
thf(fact_101_Un__Int__distrib,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ B2 @ C2 ) )
      = ( inf_inf @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) @ ( sup_sup @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% Un_Int_distrib
thf(fact_102_Int__Un__distrib,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( sup_sup @ ( set @ A ) @ B2 @ C2 ) )
      = ( sup_sup @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) @ ( inf_inf @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% Int_Un_distrib
thf(fact_103_Un__Int__crazy,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) @ ( inf_inf @ ( set @ A ) @ B2 @ C2 ) ) @ ( inf_inf @ ( set @ A ) @ C2 @ A2 ) )
      = ( inf_inf @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) @ ( sup_sup @ ( set @ A ) @ B2 @ C2 ) ) @ ( sup_sup @ ( set @ A ) @ C2 @ A2 ) ) ) ).

% Un_Int_crazy
thf(fact_104_can__select__def,axiom,
    ! [A: $tType] :
      ( ( can_select @ A )
      = ( ^ [P: A > $o,A5: set @ A] :
          ? [X: A] :
            ( ( member2 @ A @ X @ A5 )
            & ( P @ X )
            & ! [Y2: A] :
                ( ( ( member2 @ A @ Y2 @ A5 )
                  & ( P @ Y2 ) )
               => ( Y2 = X ) ) ) ) ) ).

% can_select_def
thf(fact_105_fold__invariant,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Q: A > $o,P2: B > $o,S2: B,F2: A > B > B] :
      ( ! [X3: A] :
          ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
         => ( Q @ X3 ) )
     => ( ( P2 @ S2 )
       => ( ! [X3: A,S3: B] :
              ( ( Q @ X3 )
             => ( ( P2 @ S3 )
               => ( P2 @ ( F2 @ X3 @ S3 ) ) ) )
         => ( P2 @ ( fold @ A @ B @ F2 @ Xs @ S2 ) ) ) ) ) ).

% fold_invariant
thf(fact_106_List_Ofold__cong,axiom,
    ! [B: $tType,A: $tType,A3: A,B3: A,Xs: list @ B,Ys: list @ B,F2: B > A > A,G2: B > A > A] :
      ( ( A3 = B3 )
     => ( ( Xs = Ys )
       => ( ! [X3: B] :
              ( ( member2 @ B @ X3 @ ( set2 @ B @ Xs ) )
             => ( ( F2 @ X3 )
                = ( G2 @ X3 ) ) )
         => ( ( fold @ B @ A @ F2 @ Xs @ A3 )
            = ( fold @ B @ A @ G2 @ Ys @ B3 ) ) ) ) ) ).

% List.fold_cong
thf(fact_107_distinct__sorted__list__of__set,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A2: set @ A] : ( distinct @ A @ ( linord467138063of_set @ A @ A2 ) ) ) ).

% distinct_sorted_list_of_set
thf(fact_108_merge__correct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L1: list @ A,L2: list @ A] :
          ( ( ( distinct @ A @ L1 )
            & ( linorder_sorted @ A @ L1 ) )
         => ( ( ( distinct @ A @ L2 )
              & ( linorder_sorted @ A @ L2 ) )
           => ( ( distinct @ A @ ( merge @ A @ L1 @ L2 ) )
              & ( linorder_sorted @ A @ ( merge @ A @ L1 @ L2 ) )
              & ( ( set2 @ A @ ( merge @ A @ L1 @ L2 ) )
                = ( sup_sup @ ( set @ A ) @ ( set2 @ A @ L1 ) @ ( set2 @ A @ L2 ) ) ) ) ) ) ) ).

% merge_correct
thf(fact_109_set__mergesort__by__rel__merge,axiom,
    ! [A: $tType,R: A > A > $o,Xs: list @ A,Ys: list @ A] :
      ( ( set2 @ A @ ( merges2133357844_merge @ A @ R @ Xs @ Ys ) )
      = ( sup_sup @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ Ys ) ) ) ).

% set_mergesort_by_rel_merge
thf(fact_110_distinct__n__lists,axiom,
    ! [A: $tType,Xs: list @ A,N: nat] :
      ( ( distinct @ A @ Xs )
     => ( distinct @ ( list @ A ) @ ( n_lists @ A @ N @ Xs ) ) ) ).

% distinct_n_lists
thf(fact_111_distinct__concat,axiom,
    ! [A: $tType,Xs: list @ ( list @ A )] :
      ( ( distinct @ ( list @ A ) @ Xs )
     => ( ! [Ys2: list @ A] :
            ( ( member2 @ ( list @ A ) @ Ys2 @ ( set2 @ ( list @ A ) @ Xs ) )
           => ( distinct @ A @ Ys2 ) )
       => ( ! [Ys2: list @ A,Zs: list @ A] :
              ( ( member2 @ ( list @ A ) @ Ys2 @ ( set2 @ ( list @ A ) @ Xs ) )
             => ( ( member2 @ ( list @ A ) @ Zs @ ( set2 @ ( list @ A ) @ Xs ) )
               => ( ( Ys2 != Zs )
                 => ( ( inf_inf @ ( set @ A ) @ ( set2 @ A @ Ys2 ) @ ( set2 @ A @ Zs ) )
                    = ( bot_bot @ ( set @ A ) ) ) ) ) )
         => ( distinct @ A @ ( concat @ A @ Xs ) ) ) ) ) ).

% distinct_concat
thf(fact_112_sorted__list__of__set_Oinfinite,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A2: set @ A] :
          ( ~ ( finite_finite2 @ A @ A2 )
         => ( ( linord467138063of_set @ A @ A2 )
            = ( nil @ A ) ) ) ) ).

% sorted_list_of_set.infinite
thf(fact_113_not__in__set__insert,axiom,
    ! [A: $tType,X2: A,Xs: list @ A] :
      ( ~ ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X2 @ Xs )
        = ( cons @ A @ X2 @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_114_List_Oset__insert,axiom,
    ! [A: $tType,X2: A,Xs: list @ A] :
      ( ( set2 @ A @ ( insert @ A @ X2 @ Xs ) )
      = ( insert2 @ A @ X2 @ ( set2 @ A @ Xs ) ) ) ).

% List.set_insert
thf(fact_115_empty__iff,axiom,
    ! [A: $tType,C: A] :
      ~ ( member2 @ A @ C @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_116_all__not__in__conv,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( ! [X: A] :
            ~ ( member2 @ A @ X @ A2 ) )
      = ( A2
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_117_Collect__empty__eq,axiom,
    ! [A: $tType,P2: A > $o] :
      ( ( ( collect @ A @ P2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X: A] :
            ~ ( P2 @ X ) ) ) ).

% Collect_empty_eq
thf(fact_118_empty__Collect__eq,axiom,
    ! [A: $tType,P2: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P2 ) )
      = ( ! [X: A] :
            ~ ( P2 @ X ) ) ) ).

% empty_Collect_eq
thf(fact_119_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_120_insertCI,axiom,
    ! [A: $tType,A3: A,B2: set @ A,B3: A] :
      ( ( ~ ( member2 @ A @ A3 @ B2 )
       => ( A3 = B3 ) )
     => ( member2 @ A @ A3 @ ( insert2 @ A @ B3 @ B2 ) ) ) ).

% insertCI
thf(fact_121_insert__iff,axiom,
    ! [A: $tType,A3: A,B3: A,A2: set @ A] :
      ( ( member2 @ A @ A3 @ ( insert2 @ A @ B3 @ A2 ) )
      = ( ( A3 = B3 )
        | ( member2 @ A @ A3 @ A2 ) ) ) ).

% insert_iff
thf(fact_122_insert__absorb2,axiom,
    ! [A: $tType,X2: A,A2: set @ A] :
      ( ( insert2 @ A @ X2 @ ( insert2 @ A @ X2 @ A2 ) )
      = ( insert2 @ A @ X2 @ A2 ) ) ).

% insert_absorb2
thf(fact_123_inf__bot__left,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X2: A] :
          ( ( inf_inf @ A @ ( bot_bot @ A ) @ X2 )
          = ( bot_bot @ A ) ) ) ).

% inf_bot_left
thf(fact_124_inf__bot__right,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X2: A] :
          ( ( inf_inf @ A @ X2 @ ( bot_bot @ A ) )
          = ( bot_bot @ A ) ) ) ).

% inf_bot_right
thf(fact_125_bot__eq__sup__iff,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( ( bot_bot @ A )
            = ( sup_sup @ A @ X2 @ Y ) )
          = ( ( X2
              = ( bot_bot @ A ) )
            & ( Y
              = ( bot_bot @ A ) ) ) ) ) ).

% bot_eq_sup_iff
thf(fact_126_sup__eq__bot__iff,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X2: A,Y: A] :
          ( ( ( sup_sup @ A @ X2 @ Y )
            = ( bot_bot @ A ) )
          = ( ( X2
              = ( bot_bot @ A ) )
            & ( Y
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_eq_bot_iff
thf(fact_127_sup__bot_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ A3 )
          = A3 ) ) ).

% sup_bot.left_neutral
thf(fact_128_sup__bot_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ( ( sup_sup @ A @ A3 @ ( bot_bot @ A ) )
          = A3 ) ) ).

% sup_bot.right_neutral
thf(fact_129_singletonI,axiom,
    ! [A: $tType,A3: A] : ( member2 @ A @ A3 @ ( insert2 @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_130_finite__insert,axiom,
    ! [A: $tType,A3: A,A2: set @ A] :
      ( ( finite_finite2 @ A @ ( insert2 @ A @ A3 @ A2 ) )
      = ( finite_finite2 @ A @ A2 ) ) ).

% finite_insert
thf(fact_131_Un__empty,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( ( sup_sup @ ( set @ A ) @ A2 @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ( A2
          = ( bot_bot @ ( set @ A ) ) )
        & ( B2
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Un_empty
thf(fact_132_Int__insert__left__if0,axiom,
    ! [A: $tType,A3: A,C2: set @ A,B2: set @ A] :
      ( ~ ( member2 @ A @ A3 @ C2 )
     => ( ( inf_inf @ ( set @ A ) @ ( insert2 @ A @ A3 @ B2 ) @ C2 )
        = ( inf_inf @ ( set @ A ) @ B2 @ C2 ) ) ) ).

% Int_insert_left_if0
thf(fact_133_Int__insert__left__if1,axiom,
    ! [A: $tType,A3: A,C2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ A3 @ C2 )
     => ( ( inf_inf @ ( set @ A ) @ ( insert2 @ A @ A3 @ B2 ) @ C2 )
        = ( insert2 @ A @ A3 @ ( inf_inf @ ( set @ A ) @ B2 @ C2 ) ) ) ) ).

% Int_insert_left_if1
thf(fact_134_insert__inter__insert,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ ( insert2 @ A @ A3 @ A2 ) @ ( insert2 @ A @ A3 @ B2 ) )
      = ( insert2 @ A @ A3 @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% insert_inter_insert
thf(fact_135_Int__insert__right__if0,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B2: set @ A] :
      ( ~ ( member2 @ A @ A3 @ A2 )
     => ( ( inf_inf @ ( set @ A ) @ A2 @ ( insert2 @ A @ A3 @ B2 ) )
        = ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% Int_insert_right_if0
thf(fact_136_Int__insert__right__if1,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ A3 @ A2 )
     => ( ( inf_inf @ ( set @ A ) @ A2 @ ( insert2 @ A @ A3 @ B2 ) )
        = ( insert2 @ A @ A3 @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) ) ).

% Int_insert_right_if1
thf(fact_137_Un__insert__left,axiom,
    ! [A: $tType,A3: A,B2: set @ A,C2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( insert2 @ A @ A3 @ B2 ) @ C2 )
      = ( insert2 @ A @ A3 @ ( sup_sup @ ( set @ A ) @ B2 @ C2 ) ) ) ).

% Un_insert_left
thf(fact_138_Un__insert__right,axiom,
    ! [A: $tType,A2: set @ A,A3: A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( insert2 @ A @ A3 @ B2 ) )
      = ( insert2 @ A @ A3 @ ( sup_sup @ ( set @ A ) @ A2 @ B2 ) ) ) ).

% Un_insert_right
thf(fact_139_mergesort__by__rel__merge__simps_I3_J,axiom,
    ! [A: $tType,R: A > A > $o,Ys: list @ A] :
      ( ( merges2133357844_merge @ A @ R @ ( nil @ A ) @ Ys )
      = Ys ) ).

% mergesort_by_rel_merge_simps(3)
thf(fact_140_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( rotate1 @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% rotate1_is_Nil_conv
thf(fact_141_bind__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( nil @ B ) @ F2 )
      = ( nil @ A ) ) ).

% bind_simps(1)
thf(fact_142_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P2: A > $o] :
      ~ ( list_ex1 @ A @ P2 @ ( nil @ A ) ) ).

% list_ex1_simps(1)
thf(fact_143_set__empty,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( set2 @ A @ Xs )
        = ( bot_bot @ ( set @ A ) ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% set_empty
thf(fact_144_set__empty2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( set2 @ A @ Xs ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% set_empty2
thf(fact_145_list_Osimps_I15_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( set2 @ A @ ( cons @ A @ X21 @ X22 ) )
      = ( insert2 @ A @ X21 @ ( set2 @ A @ X22 ) ) ) ).

% list.simps(15)
thf(fact_146_disjoint__insert_I2_J,axiom,
    ! [A: $tType,A2: set @ A,B3: A,B2: set @ A] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( inf_inf @ ( set @ A ) @ A2 @ ( insert2 @ A @ B3 @ B2 ) ) )
      = ( ~ ( member2 @ A @ B3 @ A2 )
        & ( ( bot_bot @ ( set @ A ) )
          = ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) ) ).

% disjoint_insert(2)
thf(fact_147_disjoint__insert_I1_J,axiom,
    ! [A: $tType,B2: set @ A,A3: A,A2: set @ A] :
      ( ( ( inf_inf @ ( set @ A ) @ B2 @ ( insert2 @ A @ A3 @ A2 ) )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ~ ( member2 @ A @ A3 @ B2 )
        & ( ( inf_inf @ ( set @ A ) @ B2 @ A2 )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% disjoint_insert(1)
thf(fact_148_insert__disjoint_I2_J,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B2: set @ A] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( inf_inf @ ( set @ A ) @ ( insert2 @ A @ A3 @ A2 ) @ B2 ) )
      = ( ~ ( member2 @ A @ A3 @ B2 )
        & ( ( bot_bot @ ( set @ A ) )
          = ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) ) ).

% insert_disjoint(2)
thf(fact_149_insert__disjoint_I1_J,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B2: set @ A] :
      ( ( ( inf_inf @ ( set @ A ) @ ( insert2 @ A @ A3 @ A2 ) @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ~ ( member2 @ A @ A3 @ B2 )
        & ( ( inf_inf @ ( set @ A ) @ A2 @ B2 )
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% insert_disjoint(1)
thf(fact_150_sorted__single,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X2: A] : ( linorder_sorted @ A @ ( cons @ A @ X2 @ ( nil @ A ) ) ) ) ).

% sorted_single
thf(fact_151_sorted__list__of__set__empty,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linord467138063of_set @ A @ ( bot_bot @ ( set @ A ) ) )
        = ( nil @ A ) ) ) ).

% sorted_list_of_set_empty
thf(fact_152_insert__Nil,axiom,
    ! [A: $tType,X2: A] :
      ( ( insert @ A @ X2 @ ( nil @ A ) )
      = ( cons @ A @ X2 @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_153_concat__eq__Nil__conv,axiom,
    ! [A: $tType,Xss: list @ ( list @ A )] :
      ( ( ( concat @ A @ Xss )
        = ( nil @ A ) )
      = ( ! [X: list @ A] :
            ( ( member2 @ ( list @ A ) @ X @ ( set2 @ ( list @ A ) @ Xss ) )
           => ( X
              = ( nil @ A ) ) ) ) ) ).

% concat_eq_Nil_conv
thf(fact_154_Nil__eq__concat__conv,axiom,
    ! [A: $tType,Xss: list @ ( list @ A )] :
      ( ( ( nil @ A )
        = ( concat @ A @ Xss ) )
      = ( ! [X: list @ A] :
            ( ( member2 @ ( list @ A ) @ X @ ( set2 @ ( list @ A ) @ Xss ) )
           => ( X
              = ( nil @ A ) ) ) ) ) ).

% Nil_eq_concat_conv
thf(fact_155_sorted__list__of__set__eq__Nil__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A2: set @ A] :
          ( ( finite_finite2 @ A @ A2 )
         => ( ( ( linord467138063of_set @ A @ A2 )
              = ( nil @ A ) )
            = ( A2
              = ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% sorted_list_of_set_eq_Nil_iff
thf(fact_156_infinite__finite__induct,axiom,
    ! [A: $tType,P2: ( set @ A ) > $o,A2: set @ A] :
      ( ! [A6: set @ A] :
          ( ~ ( finite_finite2 @ A @ A6 )
         => ( P2 @ A6 ) )
     => ( ( P2 @ ( bot_bot @ ( set @ A ) ) )
       => ( ! [X3: A,F5: set @ A] :
              ( ( finite_finite2 @ A @ F5 )
             => ( ~ ( member2 @ A @ X3 @ F5 )
               => ( ( P2 @ F5 )
                 => ( P2 @ ( insert2 @ A @ X3 @ F5 ) ) ) ) )
         => ( P2 @ A2 ) ) ) ) ).

% infinite_finite_induct
thf(fact_157_finite__ne__induct,axiom,
    ! [A: $tType,F3: set @ A,P2: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ F3 )
     => ( ( F3
         != ( bot_bot @ ( set @ A ) ) )
       => ( ! [X3: A] : ( P2 @ ( insert2 @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) )
         => ( ! [X3: A,F5: set @ A] :
                ( ( finite_finite2 @ A @ F5 )
               => ( ( F5
                   != ( bot_bot @ ( set @ A ) ) )
                 => ( ~ ( member2 @ A @ X3 @ F5 )
                   => ( ( P2 @ F5 )
                     => ( P2 @ ( insert2 @ A @ X3 @ F5 ) ) ) ) ) )
           => ( P2 @ F3 ) ) ) ) ) ).

% finite_ne_induct
thf(fact_158_finite_Oinducts,axiom,
    ! [A: $tType,X2: set @ A,P2: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ X2 )
     => ( ( P2 @ ( bot_bot @ ( set @ A ) ) )
       => ( ! [A6: set @ A,A7: A] :
              ( ( finite_finite2 @ A @ A6 )
             => ( ( P2 @ A6 )
               => ( P2 @ ( insert2 @ A @ A7 @ A6 ) ) ) )
         => ( P2 @ X2 ) ) ) ) ).

% finite.inducts
thf(fact_159_finite__induct,axiom,
    ! [A: $tType,F3: set @ A,P2: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ F3 )
     => ( ( P2 @ ( bot_bot @ ( set @ A ) ) )
       => ( ! [X3: A,F5: set @ A] :
              ( ( finite_finite2 @ A @ F5 )
             => ( ~ ( member2 @ A @ X3 @ F5 )
               => ( ( P2 @ F5 )
                 => ( P2 @ ( insert2 @ A @ X3 @ F5 ) ) ) ) )
         => ( P2 @ F3 ) ) ) ) ).

% finite_induct
thf(fact_160_finite_Osimps,axiom,
    ! [A: $tType] :
      ( ( finite_finite2 @ A )
      = ( ^ [A4: set @ A] :
            ( ( A4
              = ( bot_bot @ ( set @ A ) ) )
            | ? [A5: set @ A,B4: A] :
                ( ( A4
                  = ( insert2 @ A @ B4 @ A5 ) )
                & ( finite_finite2 @ A @ A5 ) ) ) ) ) ).

% finite.simps
thf(fact_161_finite_Ocases,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( finite_finite2 @ A @ A3 )
     => ( ( A3
         != ( bot_bot @ ( set @ A ) ) )
       => ~ ! [A6: set @ A] :
              ( ? [A7: A] :
                  ( A3
                  = ( insert2 @ A @ A7 @ A6 ) )
             => ~ ( finite_finite2 @ A @ A6 ) ) ) ) ).

% finite.cases
thf(fact_162_singleton__Un__iff,axiom,
    ! [A: $tType,X2: A,A2: set @ A,B2: set @ A] :
      ( ( ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) )
        = ( sup_sup @ ( set @ A ) @ A2 @ B2 ) )
      = ( ( ( A2
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% singleton_Un_iff
thf(fact_163_Un__singleton__iff,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,X2: A] :
      ( ( ( sup_sup @ ( set @ A ) @ A2 @ B2 )
        = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( ( A2
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% Un_singleton_iff
thf(fact_164_insert__is__Un,axiom,
    ! [A: $tType] :
      ( ( insert2 @ A )
      = ( ^ [A4: A] : ( sup_sup @ ( set @ A ) @ ( insert2 @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% insert_is_Un
thf(fact_165_inter__sorted_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [V: A,Va: list @ A] :
          ( ( sorted2037043510sorted @ A @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
          = ( nil @ A ) ) ) ).

% inter_sorted.simps(2)
thf(fact_166_product_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Uu: list @ B] :
      ( ( product @ A @ B @ ( nil @ A ) @ Uu )
      = ( nil @ ( product_prod @ A @ B ) ) ) ).

% product.simps(1)
thf(fact_167_merge_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [V: A,Va: list @ A] :
          ( ( merge @ A @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
          = ( cons @ A @ V @ Va ) ) ) ).

% merge.simps(2)
thf(fact_168_merge_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: list @ A] :
          ( ( merge @ A @ ( nil @ A ) @ L2 )
          = L2 ) ) ).

% merge.simps(1)
thf(fact_169_concat_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( concat @ A @ ( nil @ ( list @ A ) ) )
      = ( nil @ A ) ) ).

% concat.simps(1)
thf(fact_170_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_171_mergesort__by__rel__merge_Osimps_I3_J,axiom,
    ! [A: $tType,R: A > A > $o,V: A,Va: list @ A] :
      ( ( merges2133357844_merge @ A @ R @ ( nil @ A ) @ ( cons @ A @ V @ Va ) )
      = ( cons @ A @ V @ Va ) ) ).

% mergesort_by_rel_merge.simps(3)
thf(fact_172_mergesort__by__rel__merge__simps_I2_J,axiom,
    ! [A: $tType,R: A > A > $o,Xs: list @ A] :
      ( ( merges2133357844_merge @ A @ R @ Xs @ ( nil @ A ) )
      = Xs ) ).

% mergesort_by_rel_merge_simps(2)
thf(fact_173_mergesort__by__rel__merge__simps_I1_J,axiom,
    ! [A: $tType,R: A > A > $o,X2: A,Y: A,Xs: list @ A,Ys: list @ A] :
      ( ( ( R @ X2 @ Y )
       => ( ( merges2133357844_merge @ A @ R @ ( cons @ A @ X2 @ Xs ) @ ( cons @ A @ Y @ Ys ) )
          = ( cons @ A @ X2 @ ( merges2133357844_merge @ A @ R @ Xs @ ( cons @ A @ Y @ Ys ) ) ) ) )
      & ( ~ ( R @ X2 @ Y )
       => ( ( merges2133357844_merge @ A @ R @ ( cons @ A @ X2 @ Xs ) @ ( cons @ A @ Y @ Ys ) )
          = ( cons @ A @ Y @ ( merges2133357844_merge @ A @ R @ ( cons @ A @ X2 @ Xs ) @ Ys ) ) ) ) ) ).

% mergesort_by_rel_merge_simps(1)
thf(fact_174_emptyE,axiom,
    ! [A: $tType,A3: A] :
      ~ ( member2 @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_175_insertE,axiom,
    ! [A: $tType,A3: A,B3: A,A2: set @ A] :
      ( ( member2 @ A @ A3 @ ( insert2 @ A @ B3 @ A2 ) )
     => ( ( A3 != B3 )
       => ( member2 @ A @ A3 @ A2 ) ) ) ).

% insertE
thf(fact_176_equals0D,axiom,
    ! [A: $tType,A2: set @ A,A3: A] :
      ( ( A2
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member2 @ A @ A3 @ A2 ) ) ).

% equals0D
thf(fact_177_equals0I,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ! [Y4: A] :
          ~ ( member2 @ A @ Y4 @ A2 )
     => ( A2
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_178_insertI1,axiom,
    ! [A: $tType,A3: A,B2: set @ A] : ( member2 @ A @ A3 @ ( insert2 @ A @ A3 @ B2 ) ) ).

% insertI1
thf(fact_179_insertI2,axiom,
    ! [A: $tType,A3: A,B2: set @ A,B3: A] :
      ( ( member2 @ A @ A3 @ B2 )
     => ( member2 @ A @ A3 @ ( insert2 @ A @ B3 @ B2 ) ) ) ).

% insertI2
thf(fact_180_ex__in__conv,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( ? [X: A] : ( member2 @ A @ X @ A2 ) )
      = ( A2
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_181_Set_Oset__insert,axiom,
    ! [A: $tType,X2: A,A2: set @ A] :
      ( ( member2 @ A @ X2 @ A2 )
     => ~ ! [B6: set @ A] :
            ( ( A2
              = ( insert2 @ A @ X2 @ B6 ) )
           => ( member2 @ A @ X2 @ B6 ) ) ) ).

% Set.set_insert
thf(fact_182_singletonD,axiom,
    ! [A: $tType,B3: A,A3: A] :
      ( ( member2 @ A @ B3 @ ( insert2 @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B3 = A3 ) ) ).

% singletonD
thf(fact_183_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_184_revg_Oinduct,axiom,
    ! [A: $tType,P2: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X12: list @ A] : ( P2 @ ( nil @ A ) @ X12 )
     => ( ! [A7: A,As: list @ A,B7: list @ A] :
            ( ( P2 @ As @ ( cons @ A @ A7 @ B7 ) )
           => ( P2 @ ( cons @ A @ A7 @ As ) @ B7 ) )
       => ( P2 @ A0 @ A1 ) ) ) ).

% revg.induct
thf(fact_185_zipf_Oinduct,axiom,
    ! [A: $tType,C3: $tType,B: $tType,P2: ( A > B > C3 ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > C3,A1: list @ A,A22: list @ B] :
      ( ! [F4: A > B > C3] : ( P2 @ F4 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [F4: A > B > C3,A7: A,As: list @ A,B7: B,Bs: list @ B] :
            ( ( P2 @ F4 @ As @ Bs )
           => ( P2 @ F4 @ ( cons @ A @ A7 @ As ) @ ( cons @ B @ B7 @ Bs ) ) )
       => ( ! [A7: A > B > C3,V2: A,Va2: list @ A] : ( P2 @ A7 @ ( cons @ A @ V2 @ Va2 ) @ ( nil @ B ) )
         => ( ! [A7: A > B > C3,V2: B,Va2: list @ B] : ( P2 @ A7 @ ( nil @ A ) @ ( cons @ B @ V2 @ Va2 ) )
           => ( P2 @ A0 @ A1 @ A22 ) ) ) ) ) ).

% zipf.induct
thf(fact_186_insert__ident,axiom,
    ! [A: $tType,X2: A,A2: set @ A,B2: set @ A] :
      ( ~ ( member2 @ A @ X2 @ A2 )
     => ( ~ ( member2 @ A @ X2 @ B2 )
       => ( ( ( insert2 @ A @ X2 @ A2 )
            = ( insert2 @ A @ X2 @ B2 ) )
          = ( A2 = B2 ) ) ) ) ).

% insert_ident
thf(fact_187_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X222: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X222 ) ) ) ).

% list.exhaust
thf(fact_188_list_Oinducts,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,List: list @ A] :
      ( ( P2 @ ( nil @ A ) )
     => ( ! [X12: A,X23: list @ A] :
            ( ( P2 @ X23 )
           => ( P2 @ ( cons @ A @ X12 @ X23 ) ) )
       => ( P2 @ List ) ) ) ).

% list.inducts
thf(fact_189_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y2: A,Ys3: list @ A] :
            ( Xs
            = ( cons @ A @ Y2 @ Ys3 ) ) ) ) ).

% neq_Nil_conv
thf(fact_190_insert__absorb,axiom,
    ! [A: $tType,A3: A,A2: set @ A] :
      ( ( member2 @ A @ A3 @ A2 )
     => ( ( insert2 @ A @ A3 @ A2 )
        = A2 ) ) ).

% insert_absorb
thf(fact_191_insert__eq__iff,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B3: A,B2: set @ A] :
      ( ~ ( member2 @ A @ A3 @ A2 )
     => ( ~ ( member2 @ A @ B3 @ B2 )
       => ( ( ( insert2 @ A @ A3 @ A2 )
            = ( insert2 @ A @ B3 @ B2 ) )
          = ( ( ( A3 = B3 )
             => ( A2 = B2 ) )
            & ( ( A3 != B3 )
             => ? [C4: set @ A] :
                  ( ( A2
                    = ( insert2 @ A @ B3 @ C4 ) )
                  & ~ ( member2 @ A @ B3 @ C4 )
                  & ( B2
                    = ( insert2 @ A @ A3 @ C4 ) )
                  & ~ ( member2 @ A @ A3 @ C4 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_192_singleton__iff,axiom,
    ! [A: $tType,B3: A,A3: A] :
      ( ( member2 @ A @ B3 @ ( insert2 @ A @ A3 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B3 = A3 ) ) ).

% singleton_iff
thf(fact_193_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P2: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P2 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X3: A,Xs3: list @ A] : ( P2 @ ( cons @ A @ X3 @ Xs3 ) @ ( nil @ B ) )
       => ( ! [Y4: B,Ys2: list @ B] : ( P2 @ ( nil @ A ) @ ( cons @ B @ Y4 @ Ys2 ) )
         => ( ! [X3: A,Xs3: list @ A,Y4: B,Ys2: list @ B] :
                ( ( P2 @ Xs3 @ Ys2 )
               => ( P2 @ ( cons @ A @ X3 @ Xs3 ) @ ( cons @ B @ Y4 @ Ys2 ) ) )
           => ( P2 @ Xs @ Ys ) ) ) ) ) ).

% list_induct2'
thf(fact_194_splice_Oinduct,axiom,
    ! [A: $tType,P2: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X12: list @ A] : ( P2 @ ( nil @ A ) @ X12 )
     => ( ! [V2: A,Va2: list @ A] : ( P2 @ ( cons @ A @ V2 @ Va2 ) @ ( nil @ A ) )
       => ( ! [X3: A,Xs3: list @ A,Y4: A,Ys2: list @ A] :
              ( ( P2 @ Xs3 @ Ys2 )
             => ( P2 @ ( cons @ A @ X3 @ Xs3 ) @ ( cons @ A @ Y4 @ Ys2 ) ) )
         => ( P2 @ A0 @ A1 ) ) ) ) ).

% splice.induct
thf(fact_195_set__notEmptyE,axiom,
    ! [A: $tType,S: set @ A] :
      ( ( S
       != ( bot_bot @ ( set @ A ) ) )
     => ~ ! [X3: A] :
            ~ ( member2 @ A @ X3 @ S ) ) ).

% set_notEmptyE
thf(fact_196_insert__commute,axiom,
    ! [A: $tType,X2: A,Y: A,A2: set @ A] :
      ( ( insert2 @ A @ X2 @ ( insert2 @ A @ Y @ A2 ) )
      = ( insert2 @ A @ Y @ ( insert2 @ A @ X2 @ A2 ) ) ) ).

% insert_commute
thf(fact_197_not__Cons__self2,axiom,
    ! [A: $tType,X2: A,Xs: list @ A] :
      ( ( cons @ A @ X2 @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_198_transpose_Ocases,axiom,
    ! [A: $tType,X2: list @ ( list @ A )] :
      ( ( X2
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss2: list @ ( list @ A )] :
            ( X2
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss2 ) )
       => ~ ! [X3: A,Xs3: list @ A,Xss2: list @ ( list @ A )] :
              ( X2
             != ( cons @ ( list @ A ) @ ( cons @ A @ X3 @ Xs3 ) @ Xss2 ) ) ) ) ).

% transpose.cases
thf(fact_199_list__tail__coinc,axiom,
    ! [A: $tType,N1: A,R1: list @ A,N2: A,R2: list @ A] :
      ( ( ( cons @ A @ N1 @ R1 )
        = ( cons @ A @ N2 @ R2 ) )
     => ( ( N1 = N2 )
        & ( R1 = R2 ) ) ) ).

% list_tail_coinc
thf(fact_200_doubleton__eq__iff,axiom,
    ! [A: $tType,A3: A,B3: A,C: A,D: A] :
      ( ( ( insert2 @ A @ A3 @ ( insert2 @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert2 @ A @ C @ ( insert2 @ A @ D @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A3 = C )
          & ( B3 = D ) )
        | ( ( A3 = D )
          & ( B3 = C ) ) ) ) ).

% doubleton_eq_iff
thf(fact_201_insert__not__empty,axiom,
    ! [A: $tType,A3: A,A2: set @ A] :
      ( ( insert2 @ A @ A3 @ A2 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_202_singleton__inject,axiom,
    ! [A: $tType,A3: A,B3: A] :
      ( ( ( insert2 @ A @ A3 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert2 @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A3 = B3 ) ) ).

% singleton_inject
thf(fact_203_list__2pre__induct,axiom,
    ! [A: $tType,B: $tType,P2: ( list @ A ) > ( list @ B ) > $o,W1: list @ A,W2: list @ B] :
      ( ( P2 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [E: A,W12: list @ A,W22: list @ B] :
            ( ( P2 @ W12 @ W22 )
           => ( P2 @ ( cons @ A @ E @ W12 ) @ W22 ) )
       => ( ! [E: B,W13: list @ A,W23: list @ B] :
              ( ( P2 @ W13 @ W23 )
             => ( P2 @ W13 @ ( cons @ B @ E @ W23 ) ) )
         => ( P2 @ W1 @ W2 ) ) ) ) ).

% list_2pre_induct
thf(fact_204_remdups__adj_Ocases,axiom,
    ! [A: $tType,X2: list @ A] :
      ( ( X2
       != ( nil @ A ) )
     => ( ! [X3: A] :
            ( X2
           != ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Y4: A,Xs3: list @ A] :
              ( X2
             != ( cons @ A @ X3 @ ( cons @ A @ Y4 @ Xs3 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_205_merge__list_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P2: ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) > $o,A0: list @ ( list @ A ),A1: list @ ( list @ A )] :
          ( ( P2 @ ( nil @ ( list @ A ) ) @ ( nil @ ( list @ A ) ) )
         => ( ! [L3: list @ A] : ( P2 @ ( nil @ ( list @ A ) ) @ ( cons @ ( list @ A ) @ L3 @ ( nil @ ( list @ A ) ) ) )
           => ( ! [La: list @ A,Acc2: list @ ( list @ A )] :
                  ( ( P2 @ ( nil @ ( list @ A ) ) @ ( cons @ ( list @ A ) @ La @ Acc2 ) )
                 => ( P2 @ ( cons @ ( list @ A ) @ La @ Acc2 ) @ ( nil @ ( list @ A ) ) ) )
             => ( ! [La: list @ A,Acc2: list @ ( list @ A ),L3: list @ A] :
                    ( ( P2 @ ( nil @ ( list @ A ) ) @ ( cons @ ( list @ A ) @ L3 @ ( cons @ ( list @ A ) @ La @ Acc2 ) ) )
                   => ( P2 @ ( cons @ ( list @ A ) @ La @ Acc2 ) @ ( cons @ ( list @ A ) @ L3 @ ( nil @ ( list @ A ) ) ) ) )
               => ( ! [Acc2: list @ ( list @ A ),L12: list @ A,L22: list @ A,Ls: list @ ( list @ A )] :
                      ( ( P2 @ ( cons @ ( list @ A ) @ ( merge @ A @ L12 @ L22 ) @ Acc2 ) @ Ls )
                     => ( P2 @ Acc2 @ ( cons @ ( list @ A ) @ L12 @ ( cons @ ( list @ A ) @ L22 @ Ls ) ) ) )
                 => ( P2 @ A0 @ A1 ) ) ) ) ) ) ) ).

% merge_list.induct
thf(fact_206_mk__disjoint__insert,axiom,
    ! [A: $tType,A3: A,A2: set @ A] :
      ( ( member2 @ A @ A3 @ A2 )
     => ? [B6: set @ A] :
          ( ( A2
            = ( insert2 @ A @ A3 @ B6 ) )
          & ~ ( member2 @ A @ A3 @ B6 ) ) ) ).

% mk_disjoint_insert
thf(fact_207_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,A0: list @ A] :
      ( ( P2 @ ( nil @ A ) )
     => ( ! [X3: A] : ( P2 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y4: A,Xs3: list @ A] :
              ( ( ( X3 = Y4 )
               => ( P2 @ ( cons @ A @ X3 @ Xs3 ) ) )
             => ( ( ( X3 != Y4 )
                 => ( P2 @ ( cons @ A @ Y4 @ Xs3 ) ) )
               => ( P2 @ ( cons @ A @ X3 @ ( cons @ A @ Y4 @ Xs3 ) ) ) ) )
         => ( P2 @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_208_list__induct__first2,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P2 @ ( nil @ A ) )
     => ( ! [X3: A] : ( P2 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X12: A,X23: A,Xs3: list @ A] :
              ( ( P2 @ Xs3 )
             => ( P2 @ ( cons @ A @ X12 @ ( cons @ A @ X23 @ Xs3 ) ) ) )
         => ( P2 @ Xs ) ) ) ) ).

% list_induct_first2
thf(fact_209_memb__imp__not__empty,axiom,
    ! [A: $tType,X2: A,S: set @ A] :
      ( ( member2 @ A @ X2 @ S )
     => ( S
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% memb_imp_not_empty
thf(fact_210_list__all__zip_Oinduct,axiom,
    ! [A: $tType,B: $tType,P2: ( A > B > $o ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > $o,A1: list @ A,A22: list @ B] :
      ( ! [P3: A > B > $o] : ( P2 @ P3 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [P3: A > B > $o,A7: A,As: list @ A,B7: B,Bs: list @ B] :
            ( ( P2 @ P3 @ As @ Bs )
           => ( P2 @ P3 @ ( cons @ A @ A7 @ As ) @ ( cons @ B @ B7 @ Bs ) ) )
       => ( ! [P3: A > B > $o,V2: A,Va2: list @ A] : ( P2 @ P3 @ ( cons @ A @ V2 @ Va2 ) @ ( nil @ B ) )
         => ( ! [P3: A > B > $o,V2: B,Va2: list @ B] : ( P2 @ P3 @ ( nil @ A ) @ ( cons @ B @ V2 @ Va2 ) )
           => ( P2 @ A0 @ A1 @ A22 ) ) ) ) ) ).

% list_all_zip.induct
thf(fact_211_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P2: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P2 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs3: list @ A] :
              ( ( Xs3
               != ( nil @ A ) )
             => ( ( P2 @ Xs3 )
               => ( P2 @ ( cons @ A @ X3 @ Xs3 ) ) ) )
         => ( P2 @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_212_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P2: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F4: A > B,X12: list @ B] : ( P2 @ F4 @ ( nil @ A ) @ X12 )
     => ( ! [F4: A > B,A7: A,As: list @ A,Bs: list @ B] :
            ( ( P2 @ F4 @ As @ ( cons @ B @ ( F4 @ A7 ) @ Bs ) )
           => ( P2 @ F4 @ ( cons @ A @ A7 @ As ) @ Bs ) )
       => ( P2 @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_213_mergesort__by__rel__merge_Oelims,axiom,
    ! [A: $tType,X2: A > A > $o,Xa: list @ A,Xb: list @ A,Y: list @ A] :
      ( ( ( merges2133357844_merge @ A @ X2 @ Xa @ Xb )
        = Y )
     => ( ! [X3: A,Xs3: list @ A] :
            ( ( Xa
              = ( cons @ A @ X3 @ Xs3 ) )
           => ! [Y4: A,Ys2: list @ A] :
                ( ( Xb
                  = ( cons @ A @ Y4 @ Ys2 ) )
               => ~ ( ( ( X2 @ X3 @ Y4 )
                     => ( Y
                        = ( cons @ A @ X3 @ ( merges2133357844_merge @ A @ X2 @ Xs3 @ ( cons @ A @ Y4 @ Ys2 ) ) ) ) )
                    & ( ~ ( X2 @ X3 @ Y4 )
                     => ( Y
                        = ( cons @ A @ Y4 @ ( merges2133357844_merge @ A @ X2 @ ( cons @ A @ X3 @ Xs3 ) @ Ys2 ) ) ) ) ) ) )
       => ( ( ( Xb
              = ( nil @ A ) )
           => ( Y != Xa ) )
         => ~ ( ( Xa
                = ( nil @ A ) )
             => ! [V2: A,Va2: list @ A] :
                  ( ( Xb
                    = ( cons @ A @ V2 @ Va2 ) )
                 => ( Y
                   != ( cons @ A @ V2 @ Va2 ) ) ) ) ) ) ) ).

% mergesort_by_rel_merge.elims
thf(fact_214_mergesort__by__rel__merge_Oinduct,axiom,
    ! [A: $tType,P2: ( A > A > $o ) > ( list @ A ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A,A22: list @ A] :
      ( ! [R3: A > A > $o,X3: A,Xs3: list @ A,Y4: A,Ys2: list @ A] :
          ( ( ( R3 @ X3 @ Y4 )
           => ( P2 @ R3 @ Xs3 @ ( cons @ A @ Y4 @ Ys2 ) ) )
         => ( ( ~ ( R3 @ X3 @ Y4 )
             => ( P2 @ R3 @ ( cons @ A @ X3 @ Xs3 ) @ Ys2 ) )
           => ( P2 @ R3 @ ( cons @ A @ X3 @ Xs3 ) @ ( cons @ A @ Y4 @ Ys2 ) ) ) )
     => ( ! [R3: A > A > $o,Xs3: list @ A] : ( P2 @ R3 @ Xs3 @ ( nil @ A ) )
       => ( ! [R3: A > A > $o,V2: A,Va2: list @ A] : ( P2 @ R3 @ ( nil @ A ) @ ( cons @ A @ V2 @ Va2 ) )
         => ( P2 @ A0 @ A1 @ A22 ) ) ) ) ).

% mergesort_by_rel_merge.induct
thf(fact_215_mergesort__by__rel__merge__induct,axiom,
    ! [A: $tType,B: $tType,P2: ( list @ A ) > ( list @ B ) > $o,R: A > B > $o,Xs: list @ A,Ys: list @ B] :
      ( ! [Xs3: list @ A] : ( P2 @ Xs3 @ ( nil @ B ) )
     => ( ! [X12: list @ B] : ( P2 @ ( nil @ A ) @ X12 )
       => ( ! [X3: A,Xs3: list @ A,Y4: B,Ys2: list @ B] :
              ( ( R @ X3 @ Y4 )
             => ( ( P2 @ Xs3 @ ( cons @ B @ Y4 @ Ys2 ) )
               => ( P2 @ ( cons @ A @ X3 @ Xs3 ) @ ( cons @ B @ Y4 @ Ys2 ) ) ) )
         => ( ! [X3: A,Xs3: list @ A,Y4: B,Ys2: list @ B] :
                ( ~ ( R @ X3 @ Y4 )
               => ( ( P2 @ ( cons @ A @ X3 @ Xs3 ) @ Ys2 )
                 => ( P2 @ ( cons @ A @ X3 @ Xs3 ) @ ( cons @ B @ Y4 @ Ys2 ) ) ) )
           => ( P2 @ Xs @ Ys ) ) ) ) ) ).

% mergesort_by_rel_merge_induct
thf(fact_216_distinct__singleton,axiom,
    ! [A: $tType,X2: A] : ( distinct @ A @ ( cons @ A @ X2 @ ( nil @ A ) ) ) ).

% distinct_singleton
thf(fact_217_empty__set,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( set2 @ A @ ( nil @ A ) ) ) ).

% empty_set
thf(fact_218_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_219_union__set__fold,axiom,
    ! [A: $tType,Xs: list @ A,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( set2 @ A @ Xs ) @ A2 )
      = ( fold @ A @ ( set @ A ) @ ( insert2 @ A ) @ Xs @ A2 ) ) ).

% union_set_fold
thf(fact_220_finite_OinsertI,axiom,
    ! [A: $tType,A2: set @ A,A3: A] :
      ( ( finite_finite2 @ A @ A2 )
     => ( finite_finite2 @ A @ ( insert2 @ A @ A3 @ A2 ) ) ) ).

% finite.insertI
thf(fact_221_Int__insert__left,axiom,
    ! [A: $tType,A3: A,C2: set @ A,B2: set @ A] :
      ( ( ( member2 @ A @ A3 @ C2 )
       => ( ( inf_inf @ ( set @ A ) @ ( insert2 @ A @ A3 @ B2 ) @ C2 )
          = ( insert2 @ A @ A3 @ ( inf_inf @ ( set @ A ) @ B2 @ C2 ) ) ) )
      & ( ~ ( member2 @ A @ A3 @ C2 )
       => ( ( inf_inf @ ( set @ A ) @ ( insert2 @ A @ A3 @ B2 ) @ C2 )
          = ( inf_inf @ ( set @ A ) @ B2 @ C2 ) ) ) ) ).

% Int_insert_left
thf(fact_222_Int__insert__right,axiom,
    ! [A: $tType,A3: A,A2: set @ A,B2: set @ A] :
      ( ( ( member2 @ A @ A3 @ A2 )
       => ( ( inf_inf @ ( set @ A ) @ A2 @ ( insert2 @ A @ A3 @ B2 ) )
          = ( insert2 @ A @ A3 @ ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) )
      & ( ~ ( member2 @ A @ A3 @ A2 )
       => ( ( inf_inf @ ( set @ A ) @ A2 @ ( insert2 @ A @ A3 @ B2 ) )
          = ( inf_inf @ ( set @ A ) @ A2 @ B2 ) ) ) ) ).

% Int_insert_right
thf(fact_223_sup__bot__left,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X2: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ X2 )
          = X2 ) ) ).

% sup_bot_left
thf(fact_224_sup__bot__right,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X2: A] :
          ( ( sup_sup @ A @ X2 @ ( bot_bot @ A ) )
          = X2 ) ) ).

% sup_bot_right
thf(fact_225_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X2: A,A22: list @ A,A1: A] :
      ( ( member2 @ A @ X2 @ ( set2 @ A @ A22 ) )
     => ( member2 @ A @ X2 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ) ).

% list.set_intros(2)
thf(fact_226_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ A] : ( member2 @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ).

% list.set_intros(1)
thf(fact_227_set__ConsD,axiom,
    ! [A: $tType,Y: A,X2: A,Xs: list @ A] :
      ( ( member2 @ A @ Y @ ( set2 @ A @ ( cons @ A @ X2 @ Xs ) ) )
     => ( ( Y = X2 )
        | ( member2 @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_228_list_Oset__cases,axiom,
    ! [A: $tType,E2: A,A3: list @ A] :
      ( ( member2 @ A @ E2 @ ( set2 @ A @ A3 ) )
     => ( ! [Z22: list @ A] :
            ( A3
           != ( cons @ A @ E2 @ Z22 ) )
       => ~ ! [Z1: A,Z22: list @ A] :
              ( ( A3
                = ( cons @ A @ Z1 @ Z22 ) )
             => ~ ( member2 @ A @ E2 @ ( set2 @ A @ Z22 ) ) ) ) ) ).

% list.set_cases
thf(fact_229_finite_OemptyI,axiom,
    ! [A: $tType] : ( finite_finite2 @ A @ ( bot_bot @ ( set @ A ) ) ) ).

% finite.emptyI
thf(fact_230_infinite__imp__nonempty,axiom,
    ! [A: $tType,S: set @ A] :
      ( ~ ( finite_finite2 @ A @ S )
     => ( S
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% infinite_imp_nonempty
thf(fact_231_distinct__length__2__or__more,axiom,
    ! [A: $tType,A3: A,B3: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ A3 @ ( cons @ A @ B3 @ Xs ) ) )
      = ( ( A3 != B3 )
        & ( distinct @ A @ ( cons @ A @ A3 @ Xs ) )
        & ( distinct @ A @ ( cons @ A @ B3 @ Xs ) ) ) ) ).

% distinct_length_2_or_more
thf(fact_232_disjointI,axiom,
    ! [A: $tType,A3: set @ A,B3: set @ A] :
      ( ! [X3: A] :
          ( ( member2 @ A @ X3 @ A3 )
         => ~ ( member2 @ A @ X3 @ B3 ) )
     => ( ( inf_inf @ ( set @ A ) @ A3 @ B3 )
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% disjointI
thf(fact_233_Int__emptyI,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ! [X3: A] :
          ( ( member2 @ A @ X3 @ A2 )
         => ~ ( member2 @ A @ X3 @ B2 ) )
     => ( ( inf_inf @ ( set @ A ) @ A2 @ B2 )
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% Int_emptyI
thf(fact_234_Int__empty__left,axiom,
    ! [A: $tType,B2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ B2 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Int_empty_left
thf(fact_235_Int__empty__right,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( bot_bot @ ( set @ A ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Int_empty_right
thf(fact_236_disjoint__iff__not__equal,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( ( inf_inf @ ( set @ A ) @ A2 @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X: A] :
            ( ( member2 @ A @ X @ A2 )
           => ! [Y2: A] :
                ( ( member2 @ A @ Y2 @ B2 )
               => ( X != Y2 ) ) ) ) ) ).

% disjoint_iff_not_equal
thf(fact_237_Un__empty__left,axiom,
    ! [A: $tType,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ B2 )
      = B2 ) ).

% Un_empty_left
thf(fact_238_Un__empty__right,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A2 @ ( bot_bot @ ( set @ A ) ) )
      = A2 ) ).

% Un_empty_right
thf(fact_239_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : ( distinct @ A @ ( nil @ A ) ) ).

% distinct.simps(1)
thf(fact_240_fold__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F2: B > A > A,X2: B,Xs: list @ B,S2: A] :
      ( ( fold @ B @ A @ F2 @ ( cons @ B @ X2 @ Xs ) @ S2 )
      = ( fold @ B @ A @ F2 @ Xs @ ( F2 @ X2 @ S2 ) ) ) ).

% fold_simps(2)
thf(fact_241_sorted_ONil,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( linorder_sorted @ A @ ( nil @ A ) ) ) ).

% sorted.Nil
thf(fact_242_fold__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: B > A > A,S2: A] :
      ( ( fold @ B @ A @ F2 @ ( nil @ B ) @ S2 )
      = S2 ) ).

% fold_simps(1)
thf(fact_243_rotate1_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( rotate1 @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% rotate1.simps(1)
thf(fact_244_inter__sorted_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: list @ A] :
          ( ( sorted2037043510sorted @ A @ ( nil @ A ) @ L2 )
          = ( nil @ A ) ) ) ).

% inter_sorted.simps(1)
thf(fact_245_member__rec_I1_J,axiom,
    ! [A: $tType,X2: A,Xs: list @ A,Y: A] :
      ( ( member @ A @ ( cons @ A @ X2 @ Xs ) @ Y )
      = ( ( X2 = Y )
        | ( member @ A @ Xs @ Y ) ) ) ).

% member_rec(1)
thf(fact_246_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] :
      ~ ( member @ A @ ( nil @ A ) @ Y ) ).

% member_rec(2)
thf(fact_247_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,X2: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ X2 @ Xs ) )
      = ( ~ ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
        & ( distinct @ A @ Xs ) ) ) ).

% distinct.simps(2)
thf(fact_248_List_Oinsert__def,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [X: A,Xs2: list @ A] : ( if @ ( list @ A ) @ ( member2 @ A @ X @ ( set2 @ A @ Xs2 ) ) @ Xs2 @ ( cons @ A @ X @ Xs2 ) ) ) ) ).

% List.insert_def
thf(fact_249_disjnt__def,axiom,
    ! [A: $tType] :
      ( ( disjnt @ A )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( inf_inf @ ( set @ A ) @ A5 @ B5 )
            = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% disjnt_def
thf(fact_250_the__elem__eq,axiom,
    ! [A: $tType,X2: A] :
      ( ( the_elem @ A @ ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) )
      = X2 ) ).

% the_elem_eq
thf(fact_251_bot__apply,axiom,
    ! [C3: $tType,D2: $tType] :
      ( ( bot @ C3 @ ( type2 @ C3 ) )
     => ( ( bot_bot @ ( D2 > C3 ) )
        = ( ^ [X: D2] : ( bot_bot @ C3 ) ) ) ) ).

% bot_apply
thf(fact_252_is__singletonI,axiom,
    ! [A: $tType,X2: A] : ( is_singleton @ A @ ( insert2 @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_253_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_254_disjnt__iff,axiom,
    ! [A: $tType] :
      ( ( disjnt @ A )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [X: A] :
            ~ ( ( member2 @ A @ X @ A5 )
              & ( member2 @ A @ X @ B5 ) ) ) ) ).

% disjnt_iff

%----Subclasses (1)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (35)
thf(tcon_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice_1,axiom,
    ! [A8: $tType] : ( bounded_lattice @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice_2,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( bounded_lattice @ A9 @ ( type2 @ A9 ) )
     => ( bounded_lattice @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Lattices_Obounded__semilattice__sup__bot,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( bounded_lattice @ A9 @ ( type2 @ A9 ) )
     => ( bounde1808546759up_bot @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( bounded_lattice @ A9 @ ( type2 @ A9 ) )
     => ( bounded_lattice_bot @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Lattices_Osemilattice__sup,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( semilattice_sup @ A9 @ ( type2 @ A9 ) )
     => ( semilattice_sup @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Lattices_Osemilattice__inf,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( semilattice_inf @ A9 @ ( type2 @ A9 ) )
     => ( semilattice_inf @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Lattices_Odistrib__lattice,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( distrib_lattice @ A9 @ ( type2 @ A9 ) )
     => ( distrib_lattice @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Finite__Set_Ofinite,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( finite_finite @ A8 @ ( type2 @ A8 ) )
        & ( finite_finite @ A9 @ ( type2 @ A9 ) ) )
     => ( finite_finite @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Lattices_Olattice,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( lattice @ A9 @ ( type2 @ A9 ) )
     => ( lattice @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( bot @ A9 @ ( type2 @ A9 ) )
     => ( bot @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Obounded__semilattice__sup__bot_3,axiom,
    ! [A8: $tType] : ( bounde1808546759up_bot @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice__bot_4,axiom,
    ! [A8: $tType] : ( bounded_lattice_bot @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__sup_5,axiom,
    ! [A8: $tType] : ( semilattice_sup @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__inf_6,axiom,
    ! [A8: $tType] : ( semilattice_inf @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Odistrib__lattice_7,axiom,
    ! [A8: $tType] : ( distrib_lattice @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Finite__Set_Ofinite_8,axiom,
    ! [A8: $tType] :
      ( ( finite_finite @ A8 @ ( type2 @ A8 ) )
     => ( finite_finite @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Olattice_9,axiom,
    ! [A8: $tType] : ( lattice @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_10,axiom,
    ! [A8: $tType] : ( bot @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__semilattice__sup__bot_11,axiom,
    bounde1808546759up_bot @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__lattice__bot_12,axiom,
    bounded_lattice_bot @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__sup_13,axiom,
    semilattice_sup @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__inf_14,axiom,
    semilattice_inf @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Odistrib__lattice_15,axiom,
    distrib_lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Finite__Set_Ofinite_16,axiom,
    finite_finite @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Olattice_17,axiom,
    lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Obot_18,axiom,
    bot @ $o @ ( type2 @ $o ) ).

thf(tcon_Product__Type_Oprod___Lattices_Osemilattice__sup_19,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( linorder @ A8 @ ( type2 @ A8 ) )
        & ( linorder @ A9 @ ( type2 @ A9 ) ) )
     => ( semilattice_sup @ ( product_prod @ A8 @ A9 ) @ ( type2 @ ( product_prod @ A8 @ A9 ) ) ) ) ).

thf(tcon_Product__Type_Oprod___Lattices_Osemilattice__inf_20,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( linorder @ A8 @ ( type2 @ A8 ) )
        & ( linorder @ A9 @ ( type2 @ A9 ) ) )
     => ( semilattice_inf @ ( product_prod @ A8 @ A9 ) @ ( type2 @ ( product_prod @ A8 @ A9 ) ) ) ) ).

thf(tcon_Product__Type_Oprod___Lattices_Odistrib__lattice_21,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( linorder @ A8 @ ( type2 @ A8 ) )
        & ( linorder @ A9 @ ( type2 @ A9 ) ) )
     => ( distrib_lattice @ ( product_prod @ A8 @ A9 ) @ ( type2 @ ( product_prod @ A8 @ A9 ) ) ) ) ).

thf(tcon_Product__Type_Oprod___Orderings_Olinorder_22,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( linorder @ A8 @ ( type2 @ A8 ) )
        & ( linorder @ A9 @ ( type2 @ A9 ) ) )
     => ( linorder @ ( product_prod @ A8 @ A9 ) @ ( type2 @ ( product_prod @ A8 @ A9 ) ) ) ) ).

thf(tcon_Product__Type_Oprod___Finite__Set_Ofinite_23,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( finite_finite @ A8 @ ( type2 @ A8 ) )
        & ( finite_finite @ A9 @ ( type2 @ A9 ) ) )
     => ( finite_finite @ ( product_prod @ A8 @ A9 ) @ ( type2 @ ( product_prod @ A8 @ A9 ) ) ) ) ).

thf(tcon_Product__Type_Oprod___Lattices_Olattice_24,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( linorder @ A8 @ ( type2 @ A8 ) )
        & ( linorder @ A9 @ ( type2 @ A9 ) ) )
     => ( lattice @ ( product_prod @ A8 @ A9 ) @ ( type2 @ ( product_prod @ A8 @ A9 ) ) ) ) ).

thf(tcon_Product__Type_Oprod___Orderings_Obot_25,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ( bot @ A8 @ ( type2 @ A8 ) )
        & ( bot @ A9 @ ( type2 @ A9 ) ) )
     => ( bot @ ( product_prod @ A8 @ A9 ) @ ( type2 @ ( product_prod @ A8 @ A9 ) ) ) ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P2: $o] :
      ( ( P2 = $true )
      | ( P2 = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X2: A,Y: A] :
      ( ( if @ A @ $false @ X2 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X2: A,Y: A] :
      ( ( if @ A @ $true @ X2 @ Y )
      = X2 ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( distinct @ a @ ( sorted2037043510sorted @ a @ l1 @ l2 ) )
    & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ l1 @ l2 ) )
    & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ l1 @ l2 ) )
      = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ l1 ) @ ( set2 @ a @ l2 ) ) ) ) ).

%------------------------------------------------------------------------------
